####################################################
### code chunk number : Simulations: Consistency
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
ptm = proc.time()

## initialization
mu0 = 3; mu0    ## hyperparameter
k0 = 1          ## hyperparameter
v0 = 6; v0      ## hyperparameter
sigma0 = 1      ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0
# N = 1e4 * 2^c(0, 1, 2, 3, 4); N       ## sample size
N = 1e4 * 2^c(0, 1, 2, 3, 4); N      ## sample size
L_N = length(N); L_N ## the length of N
M = 100              ## number of simulations, to calculate the probability

set.seed(2) 
n = N[L_N]
X = matrix(0, nrow = M, ncol = n)
for (m in 1:M){
	theta_m = 1 / rgamma(n = n, shape = v0 / 2, rate = v0 * sigma0^2 / 2)
	mu_m = rnorm(n = n, mean = mu0, sd = sqrt(theta_m / k0))
	X[m, ] = rnorm(n = n, mean = mu_m, sd = sqrt(theta_m))
}

## Histogram,
hist(X[1, ], probability = TRUE,
    main = paste("Histogram of" , "X[1, ]"), 
    xlab = "x")
lines(density(X[1, ]), col = "blue")

F1 = F2 = matrix(0, nrow = L_N, ncol = 3)
colnames(F1) = c("mu0_1", "v0_1", "u0_1")
colnames(F2) = c("mu0_2", "v0_2", "u0_2")
mu0_1 = v0_1 = u0_1 = matrix(0, nrow = L_N, ncol = M)
mu0_2 = v0_2 = u0_2 = matrix(0, nrow = L_N, ncol = M)
Index = matrix(0, nrow = L_N, ncol = M)
for (j in 1:L_N){
	cat("\n"); print(paste("In this cycle, j = ", j, sep = "")); cat("\n")
	n = N[j]; n
	mu0_1_v0_1_u0_1 = mu0_2_v0_2_u0_2 = matrix(0, nrow = M, ncol = 3)
	for (m in 1:M){
		cat("\n"); print(paste("In this cycle, m = ", m, sep = "")); cat("\n")
		
		## Note that x is the sample, it is used in the calculation of the MLEs. 
		## See moment_fun().
		x = X[m, 1:n]
		mu0_1_v0_1_u0_1[m, ] = Moment_estimators(x)
		cat("mu0_1_v0_1_u0_1[m, ] \n"); print(mu0_1_v0_1_u0_1[m, ]); cat("\n")
		
		## The MLE is very sensitive to the initial guess. 
		## The moment estimator is usually a good initial guess.
		res_Newtons_m = Newtons(fun = moment_fun, p = mu0_1_v0_1_u0_1[m, ], x = x)
		Index[j, m] = res_Newtons_m$index
		mu0_2_v0_2_u0_2[m, ] = res_Newtons_m$root
		cat("mu0_2_v0_2_u0_2[m, ] \n"); print(mu0_2_v0_2_u0_2[m, ]); cat("\n")
	}
	mu0_1[j, ] = mu0_1_v0_1_u0_1[, 1]
	v0_1[j, ]  = mu0_1_v0_1_u0_1[, 2]
	u0_1[j, ]  = mu0_1_v0_1_u0_1[, 3]
	
	mu0_2[j, ] = mu0_2_v0_2_u0_2[, 1]
	v0_2[j, ]  = mu0_2_v0_2_u0_2[, 2]
	u0_2[j, ]  = mu0_2_v0_2_u0_2[, 3]
}
Index
sum_Index_2 = sum(Index == 2); sum_Index_2
sum_Index_r1_2 = sum(Index[1, ] == 2); sum_Index_r1_2
sum_Index_r2_2 = sum(Index[2, ] == 2); sum_Index_r2_2
sum_Index_r3_2 = sum(Index[3, ] == 2); sum_Index_r3_2
sum_Index_r4_2 = sum(Index[4, ] == 2); sum_Index_r4_2
sum_Index_r5_2 = sum(Index[5, ] == 2); sum_Index_r5_2

Abs_mu0_1 = abs(mu0_1 - matrix(mu0, nrow = L_N, ncol = M)); ## round(Abs_mu0_1, 3)
Abs_v0_1  = abs(v0_1 - matrix(v0, nrow = L_N, ncol = M)); ## round(Abs_v0_1, 3)
Abs_u0_1  = abs(u0_1 - matrix(u0, nrow = L_N, ncol = M)); ## round(Abs_u0_1, 3)

Abs_mu0_2 = abs(mu0_2 - matrix(mu0, nrow = L_N, ncol = M)); ## round(Abs_mu0_2, 3)
Abs_v0_2  = abs(v0_2 - matrix(v0, nrow = L_N, ncol = M)); ## round(Abs_v0_2, 3)
Abs_u0_2  = abs(u0_2 - matrix(u0, nrow = L_N, ncol = M)); ## round(Abs_u0_2, 3)

## epsilon = 1, 0.5, 0.1
## moment estimator
epsilon = 1
F1[, 1] = apply((Abs_mu0_1 >= epsilon), 1, mean)
F1[, 2] = apply((Abs_v0_1  >= epsilon), 1, mean)
F1[, 3] = apply((Abs_u0_1  >= epsilon), 1, mean)
round(F1, 3)
A1 = F1

epsilon = 0.5
F1[, 1] = apply((Abs_mu0_1 >= epsilon), 1, mean)
F1[, 2] = apply((Abs_v0_1  >= epsilon), 1, mean)
F1[, 3] = apply((Abs_u0_1  >= epsilon), 1, mean)
round(F1, 3)
A2 = F1

epsilon = 0.1
F1[, 1] = apply((Abs_mu0_1 >= epsilon), 1, mean)
F1[, 2] = apply((Abs_v0_1  >= epsilon), 1, mean)
F1[, 3] = apply((Abs_u0_1  >= epsilon), 1, mean)
round(F1, 3)
A3 = F1

## MLE
epsilon = 1
F2[, 1] = apply((Abs_mu0_2 >= epsilon), 1, mean)
F2[, 2] = apply((Abs_v0_2  >= epsilon), 1, mean)
F2[, 3] = apply((Abs_u0_2  >= epsilon), 1, mean)
round(F2, 3)
A4 = F2

epsilon = 0.5
F2[, 1] = apply((Abs_mu0_2 >= epsilon), 1, mean)
F2[, 2] = apply((Abs_v0_2  >= epsilon), 1, mean)
F2[, 3] = apply((Abs_u0_2  >= epsilon), 1, mean)
round(F2, 3)
A5 = F2

epsilon = 0.1
F2[, 1] = apply((Abs_mu0_2 >= epsilon), 1, mean)
F2[, 2] = apply((Abs_v0_2  >= epsilon), 1, mean)
F2[, 3] = apply((Abs_u0_2  >= epsilon), 1, mean)
round(F2, 3)
A6 = F2

A = cbind(rbind(A1, A2, A3), rbind(A4, A5, A6))
A = format(round(A, 2), nsmall = 2); A
Generate_Matrix_Latex(A)

## about 30.19s for N = 1e4 * 2^c(0, 1, 2, 3, 4, 5)
time_new = proc.time() - ptm; time_new

